/* ==================================================================
File        : fog.hlsl
Description : Common fog functions. Used by Ubershader and debris.hlsl

================================================================= */

#if !defined(UBERSHADER) || (FOG_STAGE == FOG_VERTEX_PLANAR_EXPONENTIAL2)

inline float vs_fogVertexPlanarExponential2(float4 worldPosition, float3 eyePosition)
{
	half fogPlaneDist = max(0.0, ((fog_params.z - worldCamPos.y) / max(0.00001,normalize(worldPosition.xyz - worldCamPos.xyz).y)) - fog_params.x);
	half geometryDist = max(0.0,  length(eyePosition) - fog_params.x);

	// The following three lines reproduce the behaviour of the conditional code block shown below.
	half a = step(fog_params.z, worldCamPos.y);
	half b = step(fog_params.z, worldPosition.y);
	half dist = (worldCamPos.w - worldCamPos.w * b + b) * geometryDist + (a - b) * (1.0 - worldCamPos.w) * fogPlaneDist;

	//			if (camera is above the fog plane)
	//				if (geometry is above the fog plane)
	//					fog distance = geometry distance
	//				else
	//					fog distance = plane distance + weighted distance from the fog plane to the geometry
	//			else
	//				if (geometry is above the fog plane)
	//					fog distance = weighted plane distance + distance from the fog plane to the geometry
	//				else
	//					fog distance = weighted geometry distance.

	// Clamp and factor in the fog density.
	dist = clamp(dist, 0.0, fog_params.y) * fog_params.w;

	// Apply the exponential fall-off profile.
	return exp(-dist * dist);
}

#endif
